CONTAINER Olight

{

	NAME Olight;

	INCLUDE Obase;



	HIDE ID_BASEOBJECT_USECOLOR;

	HIDE ID_BASEOBJECT_COLOR;

	SHOW ID_BASEOBJECT_GENERATOR_FLAG;



	GROUP Obaselist

	{

		BOOL LIGHT_ICONCOL { ANIM OFF; }

	}



	GROUP LIGHT_GROUP_GENERAL

	{

		DEFAULT 1;



		COLOR LIGHT_COLOR { OPEN; PARENTCOLLAPSE; }



		BOOL LIGHT_TEMPERATURE  { PARENTCOLLAPSE LIGHT_COLOR; }

		REAL LIGHT_TEMPERATURE_MAIN  { MIN 1000.0; MAX 10000.0; MINSLIDER 1000.0; MAXSLIDER 10000.0; CUSTOMGUI REALSLIDER; PARENTCOLLAPSE LIGHT_COLOR; }

		REAL  LIGHT_BRIGHTNESS { UNIT PERCENT; MIN -10000000.0; MAX 10000000.0; MINSLIDER 0.0; MAXSLIDER 100.0; CUSTOMGUI REALSLIDER; }

		

		LONG LIGHT_TYPE { CYCLE { LIGHT_TYPE_OMNI~5102; LIGHT_TYPE_SPOT~300000146; LIGHT_TYPE_DISTANT~300000148; LIGHT_TYPE_AREA~300000150; -1; LIGHT_TYPE_SPOTRECT; LIGHT_TYPE_PARALLEL; LIGHT_TYPE_PARSPOT; LIGHT_TYPE_PARSPOTRECT; -1; LIGHT_TYPE_PHOTOMETRIC~300000265; } }

		LONG LIGHT_SHADOWTYPE	{ CYCLE { LIGHT_SHADOWTYPE_NONE; LIGHT_SHADOWTYPE_SOFT; LIGHT_SHADOWTYPE_HARD; LIGHT_SHADOWTYPE_AREA; } }

		LONG LIGHT_VLTYPE	{ CYCLE { LIGHT_VLTYPE_NONE; LIGHT_VLTYPE_VISIBLE; LIGHT_VLTYPE_VOLUMETRIC; LIGHT_VLTYPE_INVERSEVOLUMETRIC; } }



		GROUP

		{

			COLUMNS 2;

			BOOL LIGHT_NOLIGHTRADIATION { }

			BOOL LIGHT_SHOWILLUMINATION { }



			BOOL LIGHT_DETAILS_AMBIENT { }

			BOOL LIGHT_SHOWVISIBLELIGHT { }



			BOOL LIGHT_DETAILS_DIFFUSE	{ }

			BOOL LIGHT_SHOWCLIPPING		 { }



			BOOL LIGHT_DETAILS_SPECULAR { }

			BOOL LIGHT_DETAILS_SEPARATEPASS	{ }



			BOOL LIGHT_DETAILS_GI { }

			BOOL LIGHT_AFX {ANIM OFF; }

			SEPARATOR { }

		}

	}



	GROUP LIGHT_GROUP_DETAILS

	{

		BOOL LIGHT_DETAILS_INNERCONE { }

		REAL LIGHT_DETAILS_INNERANGLE { HIDDEN; UNIT DEGREE; MIN 0.0; MAX 175.0; }

		REAL LIGHT_DETAILS_INNERRADIUS { HIDDEN; UNIT METER; MIN 0.0; }

		REAL LIGHT_DETAILS_OUTERANGLE { HIDDEN; UNIT DEGREE; MIN 0.0; MAX 175.0; }

		REAL LIGHT_DETAILS_OUTERRADIUS { HIDDEN; UNIT METER; MIN 0.0; }



		REAL LIGHT_DETAILS_ASPECTRATIO	{ MIN 0.01; MAX 100.0; STEP 0.01; }

		REAL LIGHT_DETAILS_CONTRAST { UNIT PERCENT; MIN -1000.0; MAX 1000.0; }

		BOOL LIGHT_DETAILS_SHADOWCASTER {}



		SEPARATOR { LINE; }

		GROUP LIGHT_AREADETAILS

		{

			//DEFAULT 1;

			COLUMNS 1;



			LONG LIGHT_AREADETAILS_SHAPE	{ CYCLE { LIGHT_AREADETAILS_SHAPE_DISC; LIGHT_AREADETAILS_SHAPE_RECTANGLE; LIGHT_AREADETAILS_SHAPE_LINE; LIGHT_AREADETAILS_SHAPE_SPHERE; LIGHT_AREADETAILS_SHAPE_CYLINDER; LIGHT_AREADETAILS_SHAPE_PCYLINDER; LIGHT_AREADETAILS_SHAPE_CUBE; LIGHT_AREADETAILS_SHAPE_HEMISPHERE; LIGHT_AREADETAILS_SHAPE_OBJECT; } }

			LINK LIGHT_AREADETAILS_OBJECT  { ACCEPT { Obase; }    }

			REAL LIGHT_AREADETAILS_SIZEX { UNIT METER; MIN 0.0; FORBID_SCALING; } // Forbid Scaling - as outerradius already scales it

			REAL LIGHT_AREADETAILS_SIZEY { UNIT METER; MIN 0.0; FORBID_SCALING; }

			REAL LIGHT_AREADETAILS_SIZEZ { UNIT METER; MIN 0.0; FORBID_SCALING; }

			REAL LIGHT_AREADETAILS_FALLOFF_ANGLE { UNIT DEGREE; MIN 0.0; MAX 180.0; }

			REAL LIGHT_AREADETAILS_INFINITE_ANGLE { UNIT DEGREE; MIN 0.0; MAX 90.0; STEP 0.1; }

			LONG LIGHT_AREADETAILS_SAMPLES { MIN 16; MAX 1000; }

			BOOL LIGHT_AREADETAILS_ADDGRAIN { }



			BOOL LIGHT_AREADETAILS_SHOWINRENDER	{}

			BOOL LIGHT_AREADETAILS_SHOWINSPECULAR	{}

			BOOL LIGHT_AREADETAILS_SHOWINREFLECTION {}



			REAL LIGHT_AREADETAILS_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000000.0; }

		}



		SEPARATOR { LINE; }

		LONG LIGHT_DETAILS_FALLOFF { CYCLE { LIGHT_DETAILS_FALLOFF_NONE; LIGHT_DETAILS_FALLOFF_INVERSESQUARE; -1; LIGHT_DETAILS_FALLOFF_LINEAR; LIGHT_DETAILS_FALLOFF_STEP; LIGHT_DETAILS_FALLOFF_INVERSESQUARE_CLAMPED; } }

		REAL LIGHT_DETAILS_INNERDISTANCE	{ PARENTID LIGHT_DETAILS_FALLOFF; UNIT METER; MIN 0.0; }

		REAL LIGHT_DETAILS_OUTERDISTANCE	{ PARENTID LIGHT_DETAILS_FALLOFF; UNIT METER; MIN 0.0; }

		GROUP

		{

			COLUMNS 2;

			BOOL LIGHT_DETAILS_COLFALLOFF { }

			BOOL LIGHT_DETAILS_ONLYZ	{ }

		}

		BOOL LIGHT_DETAILS_USEINNERCOLOR { }

		GRADIENT LIGHT_DETAILS_GRADIENT { ICC_BASEDOCUMENT; }



		SEPARATOR { LINE; }

		GROUP

		{

			COLUMNS 3;



			BOOL LIGHT_DETAILS_NEARCLIP	{ }

			REAL LIGHT_DETAILS_NEARFROM { UNIT METER; MIN 0.0; }

			REAL LIGHT_DETAILS_NEARTO		{ UNIT METER; MIN 0.0; }



			BOOL LIGHT_DETAILS_FARCLIP	{ }

			REAL LIGHT_DETAILS_FARFROM	{ UNIT METER; MIN 0.0; }

			REAL LIGHT_DETAILS_FARTO		{ UNIT METER; MIN 0.0; }

		}

	}



	GROUP LIGHT_GROUP_VISIBILITY

	{

		BOOL LIGHT_VISIBILITY_USEFALLOFF { }

		REAL LIGHT_VISIBILITY_FALLOFF { PARENTID LIGHT_VISIBILITY_USEFALLOFF; UNIT PERCENT; MIN 0.0; MAX 100.0; }



		BOOL LIGHT_VISIBILITY_USEEDGEFALLOFF { }

		REAL LIGHT_VISIBILITY_EDGEFALLOFF { PARENTID LIGHT_VISIBILITY_USEEDGEFALLOFF; UNIT PERCENT; MIN 0.0; MAX 100.0; }

		BOOL LIGHT_VISIBILITY_COLOREDEDGEFALLOFF { PARENTID LIGHT_VISIBILITY_USEEDGEFALLOFF; }

		SEPARATOR { LINE; }

		REAL LIGHT_VISIBILITY_INNERDISTANCE	{ UNIT METER; MIN 0.0; }

		REAL LIGHT_VISIBILITY_OUTERDISTANCE { UNIT METER; MIN 0.0; }

		VECTOR LIGHT_VISIBILITY_OUTERDISTANCEREL { PARENTID LIGHT_VISIBILITY_OUTERDISTANCE; UNIT PERCENT; MIN 0.0; MAX 10000.0; }

		SEPARATOR { LINE; }

		REAL LIGHT_VISIBILITY_SAMPLEDISTANCE { UNIT METER; MIN 0.0; }

		REAL LIGHT_VISIBILITY_BRIGHTNESS { UNIT PERCENT; MIN 0.0; MAX 10000.0; }

		REAL LIGHT_VISIBILITY_DUST { UNIT PERCENT; MIN 0.0; MAX 100.0; }

		REAL LIGHT_VISIBILITY_DITHERING { UNIT PERCENT; MIN 0.0; MAX 100.0; }

		SEPARATOR { LINE; }

		BOOL LIGHT_VISIBILITY_CUSTOMCOLORS { }

		GRADIENT LIGHT_VISIBILITY_GRADIENT { ICC_BASEDOCUMENT; }

		SEPARATOR { LINE; }

		GROUP

		{

			COLUMNS 2;

			BOOL LIGHT_VISIBILITY_ADDITIVE { }

			BOOL LIGHT_VISIBILITY_ADAPTBRIGHTNESS	{ }

		}

	}



	GROUP LIGHT_GROUP_SHADOW

	{

		GROUP

		{

			LONG LIGHT_SHADOWTYPE_VIRTUAL { CYCLE { LIGHT_SHADOWTYPE_NONE; LIGHT_SHADOWTYPE_SOFT; LIGHT_SHADOWTYPE_HARD; LIGHT_SHADOWTYPE_AREA; } }

		}

		SEPARATOR { LINE; }

		REAL LIGHT_SHADOW_DENSITY	{ UNIT PERCENT; MIN 0.0; MAX 10000.0; }

		COLOR LIGHT_SHADOW_COLOR	{ }

		BOOL LIGHT_SHADOW_TRANSPARENCY { }

		BOOL LIGHT_SHADOW_CLIPINFLUENCE { }

		SEPARATOR { LINE; }



		LONG LIGHT_SHADOW_MAPSIZE	{ ANIM OFF; CYCLE { LIGHT_SHADOW_MAPSIZE_250; LIGHT_SHADOW_MAPSIZE_500; LIGHT_SHADOW_MAPSIZE_750; LIGHT_SHADOW_MAPSIZE_1000; LIGHT_SHADOW_MAPSIZE_1250; LIGHT_SHADOW_MAPSIZE_1500; LIGHT_SHADOW_MAPSIZE_1750;LIGHT_SHADOW_MAPSIZE_2000;LIGHT_SHADOW_MAPSIZE_USER; } }

		LONG LIGHT_SHADOW_MAPSIZEX { PARENTID LIGHT_SHADOW_MAPSIZE; MIN 40; MAX 10000; }

		LONG LIGHT_SHADOW_MAPSIZEY { PARENTID LIGHT_SHADOW_MAPSIZE; MIN 40; MAX 10000; }



		STATICTEXT LIGHT_SHADOW_MEMUSAGE { }

		LONG LIGHT_SHADOW_SAMPLERADIUS { MIN 1; MAX 20; }

		BOOL LIGHT_SHADOW_ABSOLUTE { }

		REAL LIGHT_SHADOW_RELATIVEBIAS { PARENTID LIGHT_SHADOW_ABSOLUTE; UNIT PERCENT; MIN 0.0; MAX 100.0; }

		REAL LIGHT_SHADOW_ABSOLUTEBIAS { PARENTID LIGHT_SHADOW_ABSOLUTE; UNIT METER; MIN 0.0; }

		REAL LIGHT_SHADOW_PARALLELWIDTH { UNIT METER; }

		BOOL LIGHT_SHADOW_OUTLINE { }

		SEPARATOR { LINE; }

		BOOL LIGHT_SHADOW_USECONE { }

		REAL LIGHT_SHADOW_CONEANGLE	{ PARENTID LIGHT_SHADOW_USECONE; UNIT DEGREE; MIN 0.0; MAX 170.0; }

		BOOL LIGHT_SHADOW_SOFTCONE { PARENTID LIGHT_SHADOW_USECONE; }

		SEPARATOR { LINE; }

		REAL LIGHT_SHADOW_AREAWIDTH { UNIT METER; }

		//REAL LIGHT_SHADOW_AREASAMPLES	{ UNIT PERCENT; MIN 0.0; MAX 1000.0; }

		REAL LIGHT_SHADOW_ACCURACY { UNIT PERCENT; MIN 0.0; MAX 100.0; }

		LONG LIGHT_SHADOW_MINSAMPLES { MIN 2; MAX 10000; }

		LONG LIGHT_SHADOW_MAXSAMPLES { MIN 2; MAX 10000; }

	}



	GROUP LIGHT_GROUP_PHOTOMETRIC

	{

		BOOL LIGHT_PHOTOMETRIC_UNITS			{ }

		REAL LIGHT_PHOTOMETRIC_INTENSITY 		{ MIN 0.0; MAX 10000000.0; MINSLIDER 0.0; MAXSLIDER 10000.0; CUSTOMGUI REALSLIDER; }

		LONG LIGHT_PHOTOMETRIC_UNIT 			{ CYCLE { LIGHT_PHOTOMETRIC_UNIT_LUMEN; LIGHT_PHOTOMETRIC_UNIT_CANDELA; LIGHT_PHOTOMETRIC_UNIT_LUX; } }		



		SEPARATOR { LINE; }



		BOOL LIGHT_PHOTOMETRIC_DATA 			{ }

		FILENAME LIGHT_PHOTOMETRIC_FILE 		{ ANIM OFF; }

		

		SEPARATOR { LINE; }



		BOOL LIGHT_PHOTOMETRIC_SIZE 			{ }



		SEPARATOR { LINE; }



		BITMAPBUTTON LIGHT_PHOTOMETRIC_PREVIEW 		{ }



		GROUP LIGHT_GROUP_PHOTOMETRIC_INFO

		{

			STATICTEXT LIGHT_PHOTOMETRIC_INFO_MANUFAC	{ ANIM OFF;  BORDER; }

			STATICTEXT LIGHT_PHOTOMETRIC_INFO_LUMCAT	{ ANIM OFF;  BORDER; }

			STATICTEXT LIGHT_PHOTOMETRIC_INFO_LUMINAIRE	{ ANIM OFF;  BORDER; }

			STATICTEXT LIGHT_PHOTOMETRIC_INFO_LAMPCAT	{ ANIM OFF;  BORDER; }

			STATICTEXT LIGHT_PHOTOMETRIC_INFO_LAMP		{ ANIM OFF;  BORDER; }

		}

	}



	GROUP LIGHT_GROUP_CAUSTICS

	{

		BOOL LIGHT_CAUSTIC_ENABLE	{ }

		REAL LIGHT_CAUSTIC_ENERGY	{ PARENTID LIGHT_CAUSTIC_ENABLE; UNIT PERCENT; MIN 0.0; }

		LONG LIGHT_CAUSTIC_PHOTONS { PARENTID LIGHT_CAUSTIC_ENABLE; MIN 10; MAX 10000000; }

		SEPARATOR { LINE; }

		BOOL LIGHT_VOLCAUSTIC_ENABLE	{ }

		REAL LIGHT_VOLCAUSTIC_ENERGY	{ PARENTID LIGHT_VOLCAUSTIC_ENABLE; UNIT PERCENT; MIN 0.0; }

		LONG LIGHT_VOLCAUSTIC_PHOTONS { PARENTID LIGHT_VOLCAUSTIC_ENABLE; MIN 10; MAX 2000000; }

		SEPARATOR { LINE; }

		LONG LIGHT_VOLCAUSTIC_FALLOFF	{ CYCLE { LIGHT_VOLCAUSTIC_FALLOFF_NONE; LIGHT_VOLCAUSTIC_FALLOFF_LINEAR; LIGHT_VOLCAUSTIC_FALLOFF_INVERSE; LIGHT_VOLCAUSTIC_FALLOFF_INVERSESQUARE; LIGHT_VOLCAUSTIC_FALLOFF_INVERSECUBIC; LIGHT_VOLCAUSTIC_FALLOFF_STEP; } }

		REAL LIGHT_VOLCAUSTIC_INNERDISTANCE { PARENTID LIGHT_VOLCAUSTIC_FALLOFF; UNIT METER; MIN 0.0; }

		REAL LIGHT_VOLCAUSTIC_OUTERDISTANCE { PARENTID LIGHT_VOLCAUSTIC_FALLOFF; UNIT METER; MIN 0.0; }

	}



	GROUP LIGHT_GROUP_NOISE

	{

		LONG LIGHT_NOISETYPE { CYCLE { LIGHT_NOISETYPE_NONE; LIGHT_NOISETYPE_ILLUM; LIGHT_NOISETYPE_VISIBLE; LIGHT_NOISETYPE_BOTH; } }

		LONG LIGHT_NOISE_TYPE { CYCLE { LIGHT_NOISE_TYPE_NOISE; LIGHT_NOISE_TYPE_SOFTTURBULENCE; LIGHT_NOISE_HARDTURBULENCE; LIGHT_NOISE_WAVYTURBULENCE; } }

		LONG LIGHT_NOISE_OCTAVES	{ MIN 1; MAX 8; }

		BITMAPBUTTON LIGHT_NOISE_PREVIEW { }

		SEPARATOR { LINE; }

		REAL LIGHT_NOISE_VELOCITY { UNIT PERCENT; MIN 0.0; MAX 1000.0; }

		REAL LIGHT_NOISE_BRIGHTNESS { UNIT PERCENT; MIN -1000.0; MAX 1000.0; }

		REAL LIGHT_NOISE_CONTRAST { UNIT PERCENT; MIN -1000.0; MAX 1000.0; }

		BOOL LIGHT_NOISE_LOCAL	{ }

		SEPARATOR { LINE; }

		VECTOR LIGHT_NOISE_SCALE { UNIT METER; MIN 0.0; }

		REAL LIGHT_NOISE_SCALEILLUMINATION { MIN 0.0; STEP 0.1; }

		SEPARATOR { LINE; }

		VECTOR LIGHT_NOISE_WIND { UNIT METER; }

		REAL LIGHT_NOISE_WINDVELOCITY	{ UNIT METER; MIN 0.0; }

	}



	GROUP LIGHT_GROUP_LENSEFFECTS

	{

		BITMAPBUTTON LIGHT_LENSEFFECTS_PREVIEW { }



		LONG LIGHT_LENSEFFECTS_LENSGLOW

		{

			CYCLE

			{

				LIGHT_LENSEFFECTS_LENSGLOW_INACTIVE;

				LIGHT_LENSEFFECTS_LENSGLOW_CUSTOM;

				LIGHT_LENSEFFECTS_LENSGLOW_DEFAULT;

				LIGHT_LENSEFFECTS_LENSGLOW_CINEMAR4;

				LIGHT_LENSEFFECTS_LENSGLOW_WIDEANGLE;

				LIGHT_LENSEFFECTS_LENSGLOW_ZOOM;

				LIGHT_LENSEFFECTS_LENSGLOW_HI8;

				LIGHT_LENSEFFECTS_LENSGLOW_CAMCORDER;

				LIGHT_LENSEFFECTS_LENSGLOW_SEARCHLIGHT;

				LIGHT_LENSEFFECTS_LENSGLOW_ARTIFACT;

				LIGHT_LENSEFFECTS_LENSGLOW_STAR1;

				LIGHT_LENSEFFECTS_LENSGLOW_STAR2;

				LIGHT_LENSEFFECTS_LENSGLOW_STAR3;

				LIGHT_LENSEFFECTS_LENSGLOW_PURPLE;

				LIGHT_LENSEFFECTS_LENSGLOW_FLASHLIGHT;

				LIGHT_LENSEFFECTS_LENSGLOW_SUN1;

				LIGHT_LENSEFFECTS_LENSGLOW_SUN2;

				LIGHT_LENSEFFECTS_LENSGLOW_GREY;

				LIGHT_LENSEFFECTS_LENSGLOW_BLUE1;

				LIGHT_LENSEFFECTS_LENSGLOW_BLUE2;

				LIGHT_LENSEFFECTS_LENSGLOW_RED;

				LIGHT_LENSEFFECTS_LENSGLOW_YELLOWGREEN1;

				LIGHT_LENSEFFECTS_LENSGLOW_YELLOWGREEN2;

				LIGHT_LENSEFFECTS_LENSGLOW_CANDLE;

			}

		}



		REAL LIGHT_LENSEFFECTS_GLOWSTRENGTH	{ PARENTID LIGHT_LENSEFFECTS_LENSGLOW; UNIT PERCENT; MIN 0.0; MAX 1000.0; }

		REAL LIGHT_LENSEFFECTS_GLOWSV { PARENTID LIGHT_LENSEFFECTS_LENSGLOW; MIN 0.1; MAX 10.0; STEP 0.01; }

		LENSGLOW LIGHT_LENSEFFECTS_GLOW { PARENTID LIGHT_LENSEFFECTS_LENSGLOW; }

		SEPARATOR { LINE; }



		LONG LIGHT_LENSEFFECTS_LENSREFL

		{

			CYCLE

			{

				LIGHT_LENSEFFECTS_LENSREFL_INACTIVE;

				LIGHT_LENSEFFECTS_LENSREFL_CUSTOM;

				LIGHT_LENSEFFECTS_LENSREFL_DEFAULT;

				LIGHT_LENSEFFECTS_LENSREFL_CINEMAR4;

				LIGHT_LENSEFFECTS_LENSREFL_WIDEANGLE;

				LIGHT_LENSEFFECTS_LENSREFL_ZOOM;

				LIGHT_LENSEFFECTS_LENSREFL_HI8;

				LIGHT_LENSEFFECTS_LENSREFL_CAMCORDER;

				LIGHT_LENSEFFECTS_LENSREFL_SEARCHLIGHT;

				LIGHT_LENSEFFECTS_LENSREFL_ARTIFACT;

				LIGHT_LENSEFFECTS_LENSREFL_STAR1;

				LIGHT_LENSEFFECTS_LENSREFL_STAR2;

				LIGHT_LENSEFFECTS_LENSREFL_STAR3;

				LIGHT_LENSEFFECTS_LENSREFL_PURPLE;

				LIGHT_LENSEFFECTS_LENSREFL_FLASHLIGHT1;

				LIGHT_LENSEFFECTS_LENSREFL_FLASHLIGHT2;

				LIGHT_LENSEFFECTS_LENSREFL_FLASHLIGHT3;

			}

		}



		REAL LIGHT_LENSEFFECTS_REFLSTRENGTH	{ PARENTID LIGHT_LENSEFFECTS_LENSREFL; UNIT PERCENT; MIN 0.0; MAX 1000.0; }

		REAL LIGHT_LENSEFFECTS_REFLSV { PARENTID LIGHT_LENSEFFECTS_LENSREFL; MIN 0.1; MAX 10.0; STEP 0.01; }

		BUTTON LIGHT_LENSEFFECTS_REFL_EDIT { PARENTID LIGHT_LENSEFFECTS_LENSREFL; }

		SEPARATOR { LINE; }



		REAL LIGHT_LENSEFFECTS_SCALE { UNIT PERCENT; MIN 0.0; MAX 1000.0; }

		REAL LIGHT_LENSEFFECTS_ROTATION { UNIT DEGREE; }

		REAL LIGHT_LENSEFFECTS_REFERENCE { UNIT METER; MIN 0.0; }



		GROUP

		{

			COLUMNS 2;

			BOOL LIGHT_LENSEFFECTS_USELIGHTPARAMETER { }

			BOOL LIGHT_LENSEFFECTS_FADENEARBORDER	{ }

			BOOL LIGHT_LENSEFFECTS_FADEBEHINDOBJECT { }

			BOOL LIGHT_LENSEFFECTS_FADEAPPROACHINGOBJECT { }

			BOOL LIGHT_LENSEFFECTS_SCALEGLOW { }

			BOOL LIGHT_LENSEFFECTS_SCALEREFLEXES { }

		}

	}



	GROUP LIGHT_GROUP_EXCLUSION

	{

		SCALE_V;



		GROUP

		{

			SCALE_V;



			LONG LIGHT_EXCLUSION_MODE

			{

				CYCLE

				{

					LIGHT_EXCLUSION_MODE_INCLUDE;

					LIGHT_EXCLUSION_MODE_EXCLUDE;

				}

			}

			IN_EXCLUDE  LIGHT_EXCLUSION_LIST { SCALE_V; NUM_FLAGS 4; INIT_STATE 15;

												IMAGE_01_ON 1009314; IMAGE_02_ON 1009313; IMAGE_03_ON 1009315; IMAGE_04_ON 1009316;

												IMAGE_01_OFF 1009318; IMAGE_02_OFF 1009317; IMAGE_03_OFF 1009319; IMAGE_04_OFF 1009320;

												ACCEPT { Obase; }; }

		}

	

		GROUP

		{

			SEPARATOR { }



			BOOL LIGHT_PYROCLUSTER_ILLUMINATION { }

			BOOL LIGHT_PYROCLUSTER_SHADOW { }

		}

	}

}

